﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using System.Net;
using System.IO;
using System.Text.RegularExpressions;

namespace Tlumacz
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();

            comboBox1.SelectedIndex = 0;
            Form1_Resize(null, null);
        }

        private void Form1_Resize(object sender, EventArgs e)
        {
            textBox1.Height = textBox2.Height = 
                (this.ClientRectangle.Height - comboBox1.Height) / 2;
        }

        public static string GoogleTranslate(string tekstDoPrzetlumaczenia, string paraJezykow, Encoding kodowanie)
        {
            string url = String.Format(
                "http://translate.google.pl/translate_t?text={0}&langpair={1}",
                tekstDoPrzetlumaczenia, paraJezykow);
            string tekstPoPrzetlumaczeniu = "";
            HttpWebResponse odpowiedzHTTP = null;
            Stream stream = null;
            try
            {
                HttpWebRequest zapytanieHTTP = (HttpWebRequest)HttpWebRequest.Create(url);
                odpowiedzHTTP = (HttpWebResponse)zapytanieHTTP.GetResponse();
                stream = odpowiedzHTTP.GetResponseStream();
                using (StreamReader reader = new StreamReader(stream, kodowanie))
                {
                    tekstPoPrzetlumaczeniu = reader.ReadToEnd();
                }

                Regex regexp = new Regex(
                    "(?<=<input type=hidden name=gtrans value=\")(.*?)(?=\">)",
                    RegexOptions.IgnoreCase);
                Match m = regexp.Match(tekstPoPrzetlumaczeniu);
                if (m.Success) tekstPoPrzetlumaczeniu = m.Value;
                else
                {
                    tekstPoPrzetlumaczeniu = "";
                    throw new Exception();
                }
            }
            catch
            {
                MessageBox.Show("Nie udało się przetłumaczyć tekstu.", "Błąd!");
            }
            finally
            {
                if (odpowiedzHTTP != null) odpowiedzHTTP.Close();
                if (stream != null) stream.Close();
            }
            return tekstPoPrzetlumaczeniu;
        }

        private void menuItem1_Click(object sender, EventArgs e)
        {
            Cursor.Current = Cursors.WaitCursor;

            string paraJezykow="en|pl";
            switch(comboBox1.SelectedIndex)
            {
                case 0: paraJezykow="en|pl"; break;
                case 1: paraJezykow="pl|en"; break;
            }
            textBox2.Text = GoogleTranslate(textBox1.Text, paraJezykow, Encoding.GetEncoding("ISO-8859-2"));

            Cursor.Current = Cursors.Default;
        }

        private void menuItem2_Click(object sender, EventArgs e)
        {
            Close();
        }

    }
}